/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import replicatorg.app.Base;

public class StreamLoggerThread
extends Thread {
    private InputStreamReader reader;
    private Level defaultLevel;

    public StreamLoggerThread(InputStream stream) {
        this.reader = new InputStreamReader(stream);
        this.defaultLevel = Level.INFO;
    }

    public void setDefaultLevel(Level level) {
        this.defaultLevel = level;
    }

    protected Level getLogLevel(String line) {
        return this.defaultLevel;
    }

    protected void logMessage(String line) {
        Level logLevel = this.getLogLevel(line);
        Base.logger.log(logLevel, line);
    }

    @Override
    public void run() {
        boolean atEnd = false;
        try {
            StringBuffer nextLine = new StringBuffer();
            while (!atEnd) {
                int nextChar = this.reader.read();
                if (nextChar == 10 || nextChar == 13 || nextChar == -1) {
                    if (nextLine.length() > 0) {
                        this.logMessage(nextLine.toString());
                    }
                    if (nextChar == -1) {
                        atEnd = true;
                    }
                    nextLine = new StringBuffer();
                    continue;
                }
                nextLine.append((char)nextChar);
            }
        }
        catch (IOException e) {
            Base.logger.log(Level.SEVERE, "Stream logger interrupted", e);
        }
    }
}

